<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FavoriteDepartment extends Model 
{

    protected $table = 'favorite_departments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'user_id');

    public function user_id()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function books_favorite()
    {
        return $this->hasMany('App\Models\BookFavorite', 'department_id');
    }

}